<?php

class GiftWriter
{
	private $_filePath;
	private $_count = 0;
	private $_lastTag;
	private $_tag;

	const TMP_PATH = 'protected/runtime/GiftWriter';

	const USERNICK = 'SYSTEM ImportTasks';
	const USERNAME = 'system_import_tasks';
	const PASSWORD = '3cm316JGQ^v0Vff5hrCQvxcacdUX5YbY^UI3461Pt4122M9C$^7v88eWb@2pX4Qm';
	// URL Produkcyjnej platformy
	const MOODLE_URL = 'http://kreatywnie.lublin.eu/elearning/';

	static private $_levels = array(
		1 => 'podstawowy',
		2 => 'średnio zaawansowany',
		3 => 'zaawansowany'
	);

	static private $_dziedziny = array(
		1 => 'Matematyka',
		2 => 'Fizyka',
		3 => 'Biologia',
		4 => 'Chemia'
	);

	public function __construct($tag = null)
	{
		$this->_tag = $tag;
		$data = Yii::app()->user->getState($tag);
		if (is_array($data))
		{
			$this->_count = $data['count'];
			$this->_filePath = $data['path'];
			$this->_lastTag = $data['tag'];
		}
		else
		{
			$this->_count = 0;
			if (!file_exists(self::TMP_PATH))
				mkdir (self::TMP_PATH, 0777, true);
			$this->_filePath = self::TMP_PATH . '/' . md5(uniqid()) . '.txt';
			$this->_lastTag = '';
		}
	}

	public static function storeTask(Zlecenie &$task, array &$answers)
	{
		$gift = new GiftWriter;
		$gift->addQuestion($task, $answers);
		$gift->send();
		unlink($gift->_filePath);
	}

	private function _getCourseTag(Zlecenie &$task)
	{
		return $task->idDziedziny . $task->poziom;
	}

	public function addQuestion(Zlecenie &$task, array &$answers)
	{
		$output = '';

		$poziom = self::$_levels[$task->poziom];
		$dziedzina = self::$_dziedziny[$task->idDziedziny];

		//switch course
		$currentTag = $this->_getCourseTag($task);
		if ($currentTag !== $this->_lastTag)
		{
			$output .= "// question: 0  name: Switch category to \$course$/Domyślnie"
				. "dla Quiz/$dziedzina/$dziedzina - poziom $poziom\n\$CATEGORY: \$course$/Domyślnie "
				. "dla Quiz/$dziedzina/$dziedzina - poziom $poziom\n\n";
			$this->_lastTag = $currentTag;
		}

		$name = $task->id;
		$id = $this->_count + 1;
		$content = $task->tresc;
		$baseUri = str_replace('index.php', '', Yii::app()->createAbsoluteUrl('/'));
		$image = empty($task->urlObrazka) ? '' : ('<p style="text-align:center"><img src="' .
			$baseUri . $task->urlObrazka . '" style="max-width:800px;max-height:600px;" /></p>');

		$output .= "// question: $id  name: Zadanie $name\n::Zadanie $name::[html]<p>$image $content</p>{\n";

		foreach ($answers as $ans)
			$output .= "\t=%100%$ans#<p>Bardzo dobrze!</p>\n";

		$output .= "}\n\n";

		$this->_count++;
		file_put_contents($this->_filePath, $output, FILE_APPEND);
	}

	public function close()
	{
		Yii::app()->user->setState($this->_tag, array(
			'count' => $this->_count,
			'path' => $this->_filePath,
			'tag' => $this->_lastTag
		));
	}

	public function send()
	{
		if ($this->_count <= 0)
			return;

		if (!file_exists(self::TMP_PATH))
			mkdir(self::TMP_PATH, 0777, true);

		$cookieFile = realpath(self::TMP_PATH) . '/' . md5(uniqid()) . '-cookies.txt';

		//1. login to moodle
		$ch = curl_init();
		curl_setopt_array($ch, array(
			CURLOPT_URL => self::MOODLE_URL.'/login/index.php',
			CURLOPT_POST => true,
			CURLOPT_POSTFIELDS => array(
				'username' => self::USERNAME,
				'password' => self::PASSWORD
			),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_COOKIEFILE => $cookieFile,
			CURLOPT_COOKIEJAR => $cookieFile,
			CURLOPT_USERAGENT => "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)",
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTPHEADER => array(
				'Content-type' => 'application/x-www-form-urlencoded'
			),
			CURLOPT_HEADER => false,
			CURLOPT_SSL_VERIFYPEER => false
		));
		$result = curl_exec($ch);
		if (strpos($result, self::USERNICK) === false)
			throw new Exception('Could not log in.');
		curl_close($ch);

		//2. goto import url and fetch sesskey
		$ch = curl_init();
		curl_setopt_array($ch, array(
			CURLOPT_URL => self::MOODLE_URL.'/question/import.php?courseid=62',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_COOKIEFILE => $cookieFile,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HEADER => true,
			CURLOPT_SSL_VERIFYPEER => false
		));
		$result = curl_exec($ch);
		preg_match('/","sesskey":"([a-zA-Z0-9]{1,})","/', $result, $sesArr);
		if (count($sesArr) < 2)
			throw new Exception('Error.');
		preg_match('/,"itemid":([0-9]{1,}),"/', $result, $itIdArr);
		if (count($itIdArr) < 2)
			throw new Exception('Error.');
		preg_match('/","client_id":"([a-zA-Z0-9]{1,})","/', $result, $cltIdArr);
		if (count($cltIdArr) < 2)
			throw new Exception('Error.');
		curl_close($ch);

		//3. upload file
		$ch = curl_init();
		curl_setopt_array($ch, array(
			CURLOPT_URL => self::MOODLE_URL.'/repository/repository_ajax.php?action=upload',
			CURLOPT_POST => true,
			CURLOPT_POSTFIELDS => array(
				'action' => 'upload',
				// THIS WORKS ON PHP 5.4 !
				'repo_upload_file' => '@' . realpath($this->_filePath),
				// THIS WORKS ON PHP 5.5 !
				//'repo_upload_file' => new CurlFile(realpath($this->_filePath), CFileHelper::getMimeTypeByExtension(realpath($this->_filePath))),
				'title' => '',
				'author' => Yii::app()->user->name . ' ' . Yii::app()->user->surname,
				'license' => 'allrightsreserved',
				'itemid' => $itIdArr[1],
				'repo_id' => '3',
				'p' => '',
				'page' => '',
				'env' => 'filepicker',
				'sesskey' => $sesArr[1],
				'client_id' => $cltIdArr[1],
				'maxbytes' => '-1',
				'ctx_id' => '268',
				'savepath' => '/'
			),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_COOKIEFILE => $cookieFile,
			CURLOPT_HEADER => false,
			CURLOPT_FOLLOWLOCATION => true,
		));
		$result = json_decode(curl_exec($ch));
		curl_close($ch);

		//4. import
		$ch = curl_init();
		curl_setopt_array($ch, array(
			CURLOPT_URL => self::MOODLE_URL.'/question/import.php',
			CURLOPT_POST => true,
			CURLOPT_POSTFIELDS => array(
				'courseid' => '62',
				'sesskey' => $sesArr[1],
				'_qf__question_import_form' => '1',
				'format' => 'gift',
				'category' => '47,268',
				'catfromfile' => '1',
				'contextfromfile' => '1',
				'matchgrades' => 'error',
				'stoponerror' => '1',
				'newfile' => $result->id,
				'submitbutton' => 'Import'
			),
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_COOKIEFILE => $cookieFile,
			CURLOPT_HEADER => false,
			CURLOPT_FOLLOWLOCATION => true,
		));
		curl_exec($ch);
		curl_close($ch);

		//preview
		$ch = curl_init();
		curl_setopt_array($ch, array(
			CURLOPT_URL => self::MOODLE_URL.'/question/edit.php?courseid=62&cat=47%2C268&qpage=0&category=65%2C268',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_COOKIEFILE => $cookieFile,
			CURLOPT_HEADER => false,
			CURLOPT_FOLLOWLOCATION => true,
		));
		curl_exec($ch);
		curl_close($ch);

		//logout
		$ch = curl_init();
		curl_setopt_array($ch, array(
			CURLOPT_URL => self::MOODLE_URL.'/login/logout.php',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_COOKIEFILE => $cookieFile,
			CURLOPT_HEADER => false,
			CURLOPT_FOLLOWLOCATION => true,
		));
		$result = curl_exec($ch);
		curl_close($ch);
		preg_match('/<input type="hidden" name="sesskey" value="([a-zA-Z0-9]{1,})" \/>/', $result, $sesArr);

		if (count($sesArr) >= 2)
		{
			$ch = curl_init();
			curl_setopt_array($ch, array(
				CURLOPT_URL => self::MOODLE_URL.'/login/logout.php?sesskey='.$sesArr[1],
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_COOKIEFILE => $cookieFile,
				CURLOPT_HEADER => false,
				CURLOPT_FOLLOWLOCATION => true,
			));
			curl_exec($ch);
			curl_close($ch);
		}

		unlink($cookieFile);
	}
}
